{ ----------------------------------------------------------------------- }
{ demo unit for the PROGMAN.DCU unit                                      }
{ ----------------------------------------------------------------------- }

unit Pmdemo1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    AddItemButton: TButton;
    DeleteItemButton: TButton;
    ExitButton: TBitBtn;
    CreateButton: TButton;
    DeleteButton: TButton;
    IconizeButton: TButton;
    MaximizeButton: TButton;
    MinimizeButton: TButton;
    RestoreButton: TButton;
    Panel2: TPanel;
    Timer1: TTimer;
    ReloadButton: TButton;
    Panel3: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel1: TBevel;
    Label4: TLabel;
    Panel1: TPanel;
    CBGroups: TComboBox;
    procedure AddItemButtonClick(Sender: TObject);
    procedure DeleteItemButtonClick(Sender: TObject);
    procedure CreateButtonClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure RestoreButtonClick(Sender: TObject);
    procedure IconizeButtonClick(Sender: TObject);
    procedure MaximizeButtonClick(Sender: TObject);
    procedure MinimizeButtonClick(Sender: TObject);
    procedure ReloadButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
    procedure CBGroupsEnter(Sender: TObject);
    procedure CBGroupsExit(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses ProgMan;	{*** YOUR PROGRAM SHOULD INCLUDE PROGMAN IN uses STATEMENT(S) ***}

{$R *.DFM}

{ ----------------------------------------------------------------------- }
{ demonstrate use of "AddToPMGroup" function                              }
{ ----------------------------------------------------------------------- }

procedure TForm1.AddItemButtonClick(Sender: TObject);
begin
  if AddToPMGroup('StartUp',ParamStr(0),'PM Demo Program',FALSE,TRUE) then
		begin
    	MessageBeep(0);
    	AddItemButton.Tag := AddItemButton.Tag + 1;
    end
  else
  	MessageBeep(0);
  AddItemButton.Tag := AddItemButton.Tag + 1;
end;

{ ----------------------------------------------------------------------- }
{ demonstrate use of "RemoveFromPMGroup" function                         }
{ ----------------------------------------------------------------------- }

procedure TForm1.DeleteItemButtonClick(Sender: TObject);
begin
  if RemoveFromPMGroup('StartUp','PM Demo Program',TRUE,TRUE) then
  	begin
			MessageBeep(0);
      AddItemButton.Tag := AddItemButton.Tag - 1;
    end
  else
		MessageBeep(0);
  AddItemButton.Tag := AddItemButton.Tag - 1;
end;

{ ----------------------------------------------------------------------- }
{ demonstrate use of "CreateNewPMGroup" function                          }
{ ----------------------------------------------------------------------- }

procedure TForm1.CreateButtonClick(Sender: TObject);
begin
	CreateNewPMGroup('PM DEMO Group',TRUE,TRUE);
end;

{ ----------------------------------------------------------------------- }
{ demonstrate use of "DeletePMGroup" function                             }
{ ----------------------------------------------------------------------- }

procedure TForm1.DeleteButtonClick(Sender: TObject);
begin
	DeletePMGroup('PM DEMO Group',TRUE,TRUE);
end;

{ ----------------------------------------------------------------------- }
{ demonstrate use of "ShowPMGroup" function - restored                    }
{ ----------------------------------------------------------------------- }

procedure TForm1.RestoreButtonClick(Sender: TObject);
begin
	ShowPMGroup('PM DEMO Group',pmRestored,TRUE,TRUE);
end;

{ ----------------------------------------------------------------------- }
{ demonstrate use of "ShowPMGroup" function - iconized                    }
{ ----------------------------------------------------------------------- }

procedure TForm1.IconizeButtonClick(Sender: TObject);
begin
	ShowPMGroup('PM DEMO Group',pmIconized,TRUE,TRUE);
end;

{ ----------------------------------------------------------------------- }
{ demonstrate use of "ShowPMGroup" function - maximized                   }
{ ----------------------------------------------------------------------- }

procedure TForm1.MaximizeButtonClick(Sender: TObject);
begin
	ShowPMGroup('PM DEMO Group',pmMaximized,TRUE,TRUE);
end;

{ ----------------------------------------------------------------------- }
{ demonstrate use of "ShowPMGroup" function - minimized (same as iconize) }
{ ----------------------------------------------------------------------- }

procedure TForm1.MinimizeButtonClick(Sender: TObject);
begin
	ShowPMGroup('PM DEMO Group',pmMinimized,TRUE,TRUE);
end;

{ ----------------------------------------------------------------------- }
{ demonstrate use of "ReloadPMGroup" function                             }
{ ----------------------------------------------------------------------- }

procedure TForm1.ReloadButtonClick(Sender: TObject);
begin
	{ add this program to the group so we can (maybe) show reloading it }
  AddToPMGroup('PM DEMO Group',ParamStr(0),'PM Demo Program',FALSE,TRUE);
	ReloadPMGroup('PM DEMO Group',TRUE,TRUE);
end;

{ ----------------------------------------------------------------------- }
{ FormActivate routine - YOUR PROGRAM SHOULD ESTABLISH DDE LINK HERE      }
{ ----------------------------------------------------------------------- }

procedure TForm1.FormActivate(Sender: TObject);
var
	MyItems:	TStringList;
  b:				integer;
begin

	{***************************************************}
	{ YOUR PROGRAM SHOULD DO SOMETHING SIMILAR TO THIS! }
	{***************************************************}
	{ first time form is activated, establish DDE link to Program Manager }
	if Form1.Tag = 0 then
  	begin
    	EstablishPMLink;		{*** YOUR PROGRAM MUST DO THIS ONCE AT BEGINNING ***}
    	Form1.Timer1.Enabled := TRUE;	{ start timer to keep this form returning }
      															{ to the top -- FOR THIS DEMO PROGRAM ONLY }
    end;

	{ keep track of what we've done using the "Tag" item - DEMO PROGRAM ONLY }
  Form1.Tag := 1;
	{ now this demo program will build the list of groups }
	Form1.CBGroups.Clear;
 	Form1.CBGroups.Items.AddStrings(ListPMGroup(TRUE,TRUE));
  Form1.CBGroups.Text := Form1.CBGroups.Items[0];
end;

{ ----------------------------------------------------------------------- }
{ FormClose routine - YOUR PROGRAM SHOULD CLOSE THE DDE LINK HERE         }
{ ----------------------------------------------------------------------- }

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
var
	b:	integer;
begin
	{ turn off the timer function - DEMO PROGRAM ONLY }
  Form1.Timer1.Enabled := FALSE;
  { if we created a "PM DEMO Group", delete it - DEMO PROGRAM ONLY }
	DeletePMGroup('PM DEMO Group',TRUE,TRUE);
	{ if we didn't manually delete it from StartUp group, do so now - DEMO ONLY }
	if AddItemButton.Tag > 0 then
  	for b := 1 to AddItemButton.Tag do
			RemoveFromPMGroup('StartUp','PM Demo Program',FALSE,FALSE);

	{******************************}
	{ YOUR PROGRAM SHOULD DO THIS! }
	{******************************}
  { make sure we closed the DDE link }
	ClosePMLink;    {*** YOUR PROGRAM MUST DO THIS ONCE AT END ***}

end;

{ ----------------------------------------------------------------------- }
{ FOR DEMO PROGRAM ONLY; forces this form to return to top every 1/10 sec }
{ ----------------------------------------------------------------------- }

procedure TForm1.Timer1Timer(Sender: TObject);
begin
	Form1.Show;
end;

{ ----------------------------------------------------------------------- }
{ FOR DEMO PROGRAM ONLY; keeps this form from refreshing while in listbox }
{ ----------------------------------------------------------------------- }

procedure TForm1.CBGroupsEnter(Sender: TObject);
begin
	Timer1.Enabled := FALSE;
end;

{ ----------------------------------------------------------------------- }
{ FOR DEMO PROGRAM ONLY; keeps this form from refreshing while in listbox }
{ ----------------------------------------------------------------------- }

procedure TForm1.CBGroupsExit(Sender: TObject);
begin
	Timer1.Enabled := TRUE;
end;

procedure TForm1.ExitButtonClick(Sender: TObject);
begin
	Close;
end;

end.
